<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
require_once('core_model.php');
class Price_Model extends Core_Model {
 
  public $table_config=array(
      'mater_table'=>'price_master',
      'master_table_primary_id'=>'prm_id',
      'master_table_seconrary_id'=>'',
      'item_table'=>'price_item',
      'item_table_primary_id'=>'prit_id',
      'item_table_seconrary_id'=>'prm_id',
      'sub_item_table'=>'',
      'sub_item_table_primary_id'=>'',
      'sub_item_table_seconrary_id'=>'',
      );
  
  function __construct() 
  {
    /* Call the Model constructor */
    parent::__construct($this->table_config);
  }
  	function get_price_type(){
	    $this->db->select("o.*");
        $this->db->from('master_price_type o');
        $this->db->where('o.pri_status',1);
        $this->db->order_by('o.pri_type_id','asc');
        $query = $this->db->get();
        return $query->result_array();
	}
	function get_pending_price_list_count(){
        $this->db->from('price_master o');
        $this->db->where('o.prm_status',1);
        $this->db->where('o.aproval_status',0);
        $query = $this->db->get();
        return $query->num_rows();
	}
	function get_prodcut_list(){
	    $this->db->select("o.product_id,o.product_price,o.wholesale_price,o.credit_salling_price,o.product_cost,o.retail_wholesale");
        $this->db->from('product o');
        $this->db->where('o.product_status',1);
        $query = $this->db->get();
        return $query->result_array();
	}
	function get_price_list_last_id(){
		$this->db->select("o.prm_id");
        $this->db->from('price_master o');
        $this->db->where('o.prm_status',1);
        $this->db->where('o.aproval_status',0);
        $query = $this->db->get();
        $result= $query->row_array();
        if(isset($result['prm_id'])){
            return $result['prm_id'];
        }else{
            return 0;
        }
	}
		function get_price_item_list_product_group_wise($id,$cat_id='',$item_cat_id='',$brand_id=''){
		$this->db->select("o.product_id,p.product_name,p.product_code");
        $this->db->from('price_item o');
        $this->db->join('product p','p.product_id=o.product_id','inner');
        if($cat_id){
          $this->db->where('p.cat_id',$cat_id);  
        }
         if($item_cat_id){
          $this->db->where('p.sub_cat_id',$item_cat_id);  
        }
        if($brand_id){
          $this->db->where('p.brand_id',$brand_id);  
        }
        $this->db->where('o.prm_id',$id);
        $this->db->group_by('o.product_id');
        $query = $this->db->get();
        return  $query->result_array();
	}
	
	function get_price_item_list($id){
		$this->db->select("o.*");
        $this->db->from('price_item o');
        $this->db->where('o.prm_id',$id);
        $this->db->order_by('o.price_type_id','asc');
        $query = $this->db->get();
        return  $query->result_array();
	}
	
	function save_price_master($data)
	{
		return $this->save_master_table($data);
	}
	function save_price_item($data)
	{
		return $this->save_item_table($data);
	}
		function update_price_master($data,$id)
	{
		return $this->update_master_table_by_primary_id($id,$data);
	}
	
	
	
	public function update_price_item($data,$product_id,$id,$price_type_id)
	{
	    $this->db->where('product_id',$product_id);
	    $this->db->where('prm_id',$id);
	    $this->db->where('price_type_id',$price_type_id);
        return $this->db->update('price_item',$data);
	}
	
	 function get_price_list($start, $length, $search_key_val)
    {
        $this->db->select('p.*,m.mas_name');
        $this->db->select('u.user_first_name AS added_user_first_name ,u.user_last_name AS added_user_last_name');
        $this->db->select('ua.user_first_name AS approval_user_first_name ,ua.user_last_name AS approval_user_last_name');
        $this->db->from('price_master p');
        $this->db->join('master_approval_status m', 'm.approval_status_id = p.aproval_status', 'inner');
        $this->db->join('user u', 'u.user_id = p.added_user_id', 'inner');
        $this->db->join('user ua', 'ua.user_id = p.approval_by', 'left'); 
        if ($search_key_val) {
             $this->db->where(" p.prm_ref_no LIKE '$search_key_val%'");
        }else{
    
        }
		$this->db->order_by("p.prm_id", "desc");
        if ($start != '' && $length != '') {
            $this->db->limit($length, $start);
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->result();
            } else {
                return false;
            }
        } else {
            $query = $this->db->get();
            if ($query->num_rows() > 0) {
                return $query->num_rows();
            } else {
                return false;
            }
        }
    }
    function update_product($data,$product_id)
	{
	    if($product_id>0){
	        $this->db->where('product_id',$product_id);
        return $this->db->update('product',$data);
	    }else{
	        return false;
	    }
	    
	}
	
	
	
	
	
	
	
	
	
	
	
	
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  


	function get_list_order() {
	    return $this->get_result_mater_record_data();
	}
	public function get_row_order_info($id)
	 {
	     return $this->get_row_array_mater_record_data_by_primary_id($id);
	 }
	public function delete_order($id)
	{
	    return $this->delete_master_table_by_primary_id($id);
	}
	public function disable_order($id)
	{
		$data = array(
			'status' => 0
		);	
	    return $this->update_master_table_by_primary_id($warehouse_id,$data);
	}
	public function enable_order($warehouse_id)
	{
		$data = array(
			'status' => 1
		);	
		return  $this->update_master_table_by_primary_id($warehouse_id,$data);
	}
	
	
	
	
	public function get_order_info($id)
	{
		 $this->db->select("o.*,c.cus_code,c.cus_name,u.user_first_name,u.user_last_name,w.name,w.code");
        $this->db->from('order_master o');
        $this->db->join("customer c", "c.cus_id = o.odr_customer_id", "inner");
        $this->db->join("user u", "u.user_id = o.odr_sale_rep_id", "left");
        $this->db->join("warehouses w", "w.id = o.odr_warehouse_id", "left");
        
        $this->db->where('o.odr_id',$id);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return false;
        }
	}
	public function get_order_type()
	{
		 $this->db->select("o.*");
        $this->db->from('master_order_type o');
        $this->db->where('o.odr_status',1);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
	}
	
	function get_search_category($search_key_val){
	    $this->db->select("o.*");
        $this->db->from('product_category o');
        $this->db->where("o.cat_status = 1 AND o.cat_name LIKE '%$search_key_val%'");
        $query = $this->db->get();
        return $query->result_array();
	}
	
		function get_search_item_category($search_key_val,$cat_id){
	    $this->db->select("o.*");
        $this->db->from('product_sub_category o');
        $this->db->where("o.cat_id",$cat_id);
        $this->db->where("o.sub_cat_name LIKE '%$search_key_val%'");
        $query = $this->db->get();
        return $query->result_array();
        //o.cat_id ='.$cat_id.' 
        //o.sub_cat_status = 1 AND
        // AND o.sub_cat_name LIKE '%$search_key_val%'
	}
	
	function get_search_brand($search_key_val){
	    $this->db->select("o.*");
        $this->db->from('master_brand o');
        $this->db->where("o.brand_name LIKE '%$search_key_val%'");
        $query = $this->db->get();
        return $query->result_array();
	}
	
	
	

}