<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Payment_Process_Model extends CI_Model
{
    private $tableName = 'sale_multiple_payment';
    function __construct()
    {
        parent::__construct();
    }
    function get_all_cheque_return()
    {
        $this->db->select('rp.*,mp.*,c.*,ps.p_status_name,pt.p_type_name,b.bank_name,u.user_first_name');
        $this->db->from('return_payments rp');
        $this->db->join('sale_multiple_payment mp', 'mp.smp_id = rp.payment_id','left');
        $this->db->join('user u', 'u.user_id = rp.responsible_person','left');
        $this->db->join('customer c', 'c.cus_id = mp.customer_id','left');
        $this->db->join('mstr_payment_type pt', 'pt.p_type_id = mp.payment_type','left');
        $this->db->join('mstr_payment_status ps', 'ps.payment_st_id = mp.payment_status','left');
        $this->db->join('mstr_bank b', 'b.bank_id = mp.bank_id','left');
        $this->db->where('rp.return_pay_status',1); 
        $this->db->order_by("mp.smp_id", "desc");
        $query = $this->db->get();
        return $query->result_array();
    }
   
	
    function save_cheq_return_multiple_payment(&$data_item)
    {
        if ($this->db->insert('cheque_return_payment', $data_item)) {
            return true;
        } else {
            return false;
        }
    }


    function update_cheque($id='',$data)
    {
        if ($id) {
            $this->db->where('smp_id', $id);
            return $this->db->update($this->tableName, $data);
           
        } else {
           return false;
        }
    }

    function save_sale_multiple_payment_header(&$supplier_data, $exp_id = false)
    {
        if (!$exp_id) {
            $smp_id = $this->db->insert('sale_multiple_payment', $supplier_data);
            return $smp_id;
        } else {
            $this->db->where('smp_id', $exp_id);
            return $this->db->update($this->tableName, $supplier_data);
        }
    }


    function get_all_recode()
    {
        $this->db->select('mp.*,c.sale_pymnt_paying_by,c.sale_pymnt_cheque_no,c.sale_pymnt_date_time');
        $this->db->from('sale_multiple_payment mp');
        $this->db->join('sale_payments c', 'c.smp_id = mp.smp_id','left');
        $this->db->order_by("mp.smp_id", "desc");
        $query = $this->db->get();
        return $query->result_array();
    }

    
    function get_cheque_return_list($customer_id)
    {
        $this->db->select('rp.*,mp.*,c.*,ps.p_status_name,pt.p_type_name,b.bank_name,u.user_first_name');
        $this->db->from('return_payments rp');
        $this->db->join('sale_multiple_payment mp', 'mp.smp_id = rp.payment_id','left');
        $this->db->join('user u', 'u.user_id = rp.responsible_person','left');
        $this->db->join('customer c', 'c.cus_id = mp.customer_id','left');
        $this->db->join('mstr_payment_type pt', 'pt.p_type_id = mp.payment_type','left');
        $this->db->join('mstr_payment_status ps', 'ps.payment_st_id = mp.payment_status','left');
        $this->db->where('mp.customer_id', $customer_id);
        $this->db->where('rp.return_pay_status',1);        
        $this->db->join('mstr_bank b', 'b.bank_id = mp.bank_id','left');
        $this->db->order_by("mp.smp_id", "desc");
        $query = $this->db->get();
        return $query->result();
    }

    function get_cheque_return_to_colse($customer_id)
    {
        $this->db->select('rp.*,mp.*');
        $this->db->from('return_payments rp');
        $this->db->join('sale_multiple_payment mp', 'mp.smp_id = rp.payment_id','left');          
        $this->db->where('mp.customer_id', $customer_id);
        $this->db->where('rp.return_pay_status',1);       
        $query = $this->db->get();
        return $query->result();
    }

    function close_settled_cheque($id='',$data)
    {
        if ($id) {
            $this->db->where('ret_pay_id', $id);
            return $this->db->update('return_payments', $data);
           
        } else {
           return false;
        }
    }

    function get_cheque_return_reason()
    {
        $this->db->select('*');
        $this->db->from('mstr_cheq_return_reason');      
        $this->db->where('retun_reason_status',1);       
        $query = $this->db->get();
        return $query->result_array();
    }

    function get_total_cheque_return_paid($che_r_id)
    {
        $this->db->select_sum('chp.paid_amount');
        $this->db->from('cheque_return_payment chp');
        $this->db->where('chp.ch_return_id', $che_r_id);
        $query = $this->db->get();
        $result= $query->row_array();

        if($result['paid_amount']){
            return $result['paid_amount'];
        }else{
            return 0;
        }
    }
    
    function get_panalty_charge($id)
    {
        $this->db->select('charge_amount');
        $this->db->from('mstr_cheq_return_reason');      
        $this->db->where('rt_reason_id',$id);       
        $query = $this->db->get();
        return $query->row_array();
    }    

    function get_cheque_details($id)
    {
        $this->db->select('*');
        $this->db->from('sale_multiple_payment');      
        $this->db->where('smp_id',$id);       
        $query = $this->db->get();
        return $query->row_array();
    }

    function save_cheque_return(&$data_item)
    {
        if ($this->db->insert('return_payments', $data_item)) {
            return true;
        } else {
            return false;
        }
    }
    public function get_uncomplte_multiple_payment($cus_id)
	{		
		$this->db->select('s.*,ps.p_status_name,pt.p_type_name,b.bank_name');
		$this->db->from('sale_multiple_payment s');
		$this->db->join('mstr_payment_type pt', 'pt.p_type_id = s.payment_type','left');
        $this->db->join('mstr_payment_status ps', 'ps.payment_st_id = s.payment_status','left');
        $this->db->join('mstr_bank b', 'b.bank_id = s.bank_id','left');
        $this->db->where("s.payment_settlement_status", 0);
         //$this->db->where("s.payment_status", 1);
        $this->db->where("s.customer_id", $cus_id);
		$query = $this->db->get();
		return $query->result_array(); 	
	}

	function get_total_sale_paid_by_smp_id($id)
    {
        $this->db->select_sum('sp.sale_pymnt_amount');
        $this->db->from('sale_payments sp');
        $this->db->where('sp.smp_id', $id);
        $query = $this->db->get();
        $result= $query->row_array();

        if($result['sale_pymnt_amount']){
            return $result['sale_pymnt_amount'];
        }else{
            return 0;
        }
	}
	
	function get_total_cheque_return_paid_by_smp_id($id)
    {
        $this->db->select_sum('sp.paid_amount');
        $this->db->from('cheque_return_payment sp');
        $this->db->where('sp.smp_id', $id);
        $query = $this->db->get();
        $result= $query->row_array();
        if($result['paid_amount']){
            return $result['paid_amount'];
        }else{
            return 0;
        }
	}
	
	public function close_payment($id)
	{
		if($id>0){
			$data = array(
			'payment_settlement_status' => 1
		);	
		$this->db->where('smp_id', $id);
		$this->db->update('sale_multiple_payment', $data);
		}else{
			return false;
		}
		
	}



}