<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Customer_Credit_Operation_Model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }
    //new implimentdation oustanding  start 2023-01-053
    
    
    /**  customer wise outstanding calculator**/
    public function get_customer_outstanding_for_orders($customer_id,$warehouse_id=''){
        $outstanding_amount= $this->get_customer_outstanding($customer_id,$warehouse_id);
        $credit_limit=$this->get_customer_credit_limit($customer_id);
        $cheque_retun=$this->get_customer_cheque_return_count($customer_id);
        $credit_response=array();
        if($outstanding_amount>$credit_limit){
            $credit_response=array(
                'credit_balance'=>($credit_limit-$outstanding_amount),
                'credit_status'=>0,
                'reject_reason'=>"CREDIT LIMIT EXCEED "
                );
        }else{
            $credit_response=array(
                'credit_balance'=>($credit_limit-$outstanding_amount),
                'credit_status'=>1,
                'reject_reason'=>""
                );
        }
        if($cheque_retun>0){
             $credit_response=array(
                'credit_balance'=>($credit_limit-$outstanding_amount),
                'credit_status'=>0,
                'reject_reason'=>"CHEQUE RETURN "
                );
        }
        return $credit_response;
    }
     function get_customer_credit_limit($customer_id){
          $this->db->select('s.cus_credit_limit');
        $this->db->from('customer s');
        $this->db->where('s.cus_id', $customer_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['cus_credit_limit']))
        {
            return $result['cus_credit_limit'];
        }else{
       return 0;
        }
     }
     function get_customer_cheque_return_count($customer_id){
          
        $this->db->from('return_payments r');
        $this->db->join('sale_multiple_payment s','s.smp_id=r.payment_id','inner');
        $this->db->where('s.customer_id', $customer_id);
        $this->db->where('r.return_pay_status', 1);
        $query = $this->db->get();
        return $query->num_rows();
     }
    function get_customer_outstanding($customer_id,$warehouse_id=''){
        $sale_total= $this->get_saltotal($customer_id,$warehouse_id);
        $paid_total= $this->get_paidtotal($customer_id,$warehouse_id);
        
        $outstanding=$sale_total-$paid_total;
        $outstanding= round($outstanding,3);
        if($outstanding==(-0)){
            return 0;
        }else{
            return $outstanding;
        }
    }
    //sub function ----------------------------------
    function get_saltotal($customer_id,$warehouse_id='')
    {
        $this->db->select_sum('s.sale_total');
        $this->db->from('sales s');
        if($warehouse_id){
          $this->db->where('s.warehouse_id', $warehouse_id);
        }
        $this->db->where('s.customer_id', $customer_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['sale_total']))
        {
            return $result['sale_total'];
        }else{
       return 0;
        }
    }
    function get_paidtotal($customer_id,$warehouse_id='')
    {
        $this->db->select_sum('s.smp_amount');
        $this->db->from('sale_multiple_payment s');
        if($warehouse_id){
          $this->db->where('s.warehouse_id', $warehouse_id);
        }
        $this->db->where('s.customer_id', $customer_id);
        $this->db->where('s.payment_status', 1);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['smp_amount']))
        {
            return $result['smp_amount'];
        }else{
       return 0;
        }
    }
       
     
     /* invoice wise outstanding calculator */
     
     
     function get_invoice_outstanding($invoice_id=''){
          $invoice_amount= $this->get_invoice_total($invoice_id);
          $paid_amount= $this->get_invoice_total($invoice_id);
           $outstanding=$invoice_amount-$paid_amount;
        $outstanding= round($outstanding,3);
        if($outstanding==(-0)){
            return 0;
        }else{
            return $outstanding;
        }
     }
     
     function get_invoice_total($invoice_id='')
    {
        $this->db->select('s.sale_total');
        $this->db->from('sales s');
        if($invoice_id){
          $this->db->where('s.sale_id', $invoice_id);
        }else{
          $this->db->where('s.sale_id', 0);  
        }
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['sale_total']))
        {
            return $result['sale_total'];
        }else{
       return 0;
        }
    }
    
    function get_invoice_allocated_payment_total($invoice_id='')
    {
        $this->db->select_sum('s.sale_pymnt_amount');
        $this->db->from('sale_payments s');
        if($invoice_id){
          $this->db->where('s.sale_id', $invoice_id);
        }else{
          $this->db->where('s.sale_id', 0);  
        }
        $this->db->where('s.sale_payment_type', "sale");
        
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['sale_pymnt_amount']))
        {
            return $result['sale_pymnt_amount'];
        }else{
       return 0;
        }
    }
     
     
     
     
   
}