<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');


class Store_Notes extends CI_Controller {

	var $main_menu_name = "hw";
	var $sub_menu_name = "store_notes";

	public function __construct()
	{
		parent::__construct();
		/*$this->load->model('pos_model');
		$this->load->model('customer_model');
		
		$this->load->model('sales_model');*/
		$this->load->model('common_model');
		$this->load->model('Warehouse_Model');
		$this->load->model('store_notes_model');
		$this->load->model('Marketing_Delivery_Model');
		
		date_default_timezone_set("Asia/Colombo");
	}

	public function index()
	{
	    $data['main_menu_name'] = $this->main_menu_name;
	    $data['sub_menu_name'] = $this->sub_menu_name;
	    $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
	    $data['vehicle_list']=$this->Marketing_Delivery_Model->get_all_vehicle();
	    $data['pm'] = $this->uri->segment(3);
	    $this->load->view('store_notes',$data);
	}
	function all(){
	    $data['main_menu_name'] = $this->main_menu_name;
	    $data['sub_menu_name'] = $this->sub_menu_name;
	    $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
	    $data['vehicle_list']=$this->Marketing_Delivery_Model->get_all_vehicle();
	    $data['pm'] = $this->uri->segment(3);
	    $this->load->view('store_notes_all',$data);
	}
	function list_stn(){
	    $start=$this->input->post('start');
    	$length=$this->input->post('length');
    	$search=$this->input->post('search');
	    $warehouse_id = $this->input->post('warehouse_id');
	    
	    $data = array();	
	    $totalData = $this->store_notes_model->get_all_store_notes("","",$search,$warehouse_id);
	    $totalFiltered = $totalData;
	    $stns   = $this->store_notes_model->get_all_store_notes($start,$length,$search,$warehouse_id);
	   
	    
	    	foreach ($stns as $row){
	    	    $nestedData=array(); 
	    	    $nestedData[] = $row['stn_date_time'];
	    	    $nestedData[] = $row['stn_code'];
	    	    $nestedData[] = $row['stn_no'];
	    	    
	    	    $nestedData[] = $row['sale_reference_no'];
	    	    $nestedData[] = $row['sale_total'];
	    	    
	    	    if($row['cus_id']!=1){
	    	     $nestedData[] = $row['cus_name'];
	    	     $nestedData[] = $row['cus_address'];
	    	    }else{
	    	       $nestedData[] = $row['cash_cus_name'];
	    	       $nestedData[] = $row['address_input'];
	    	       
	    	    }
	    	    $nestedData[] = $row['cus_phone']; 
	    	    
	    	    
	    	    if( $row['st_note_status']==1){
	    	       $nestedData[] = "<span class='btn btn-success'>Completed</span>"; 
	    	    }else{
	    	      $nestedData[] = "<span class='btn btn-warning'>Pending</span>";   
	    	    }
	    	    $nestedData[] = '<div class="btn-group text-left">
                                    <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                                    <ul role="menu" class="dropdown-menu pull-right">
                                    <li><a href="'.base_url().'store_notes/view/'.$row['stn_id'].'"><i class="fa fa-file-text-o"></i> Store Note Details</a></li>
                                    <li><a onClick="fbs_click('.$row['stn_id'].')" data-toggle="modal" href="#" ><i class="fa fa-print"></i> Print STN</a></li>
							</ul></div>';
				$data[]=$nestedData;
	    	}
	    $json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	    echo json_encode($json_data); 
	}
	public function view()
	{
	    $data['main_menu_name'] = $this->main_menu_name;
	    $data['sub_menu_name'] = $this->sub_menu_name;
	    
	    $stn_id = $this->uri->segment(3);
	    
	    $data['stn_info']=$this->store_notes_model->get_store_note_info($stn_id);
	    $data['stn_items']=$this->store_notes_model->get_store_note_items($data['stn_info']['warehouse_id'],$data['stn_info']['stn_no']);
	    $data['warehouse_details']=$this->Warehouse_Model->get_warehouse_info($data['stn_info']['warehouse_id']);
	    
	    /***/
	    if($this->session->userdata('ss_user_id') == 1){
	      //echo "<pre><br><br><br><br>";
	      //  print_r($data['stn_info']);
	       // print_r($data['stn_items']);
	      //echo "</pre>";
	    }
	    $this->load->view('store_notes_view',$data);
	}
	public function print()
	{
	    $stn_id = $this->input->get('stn_id');
	    
	    $data['stn_info']=$this->store_notes_model->get_store_note_info($stn_id);
	    $data['stn_items']=$this->store_notes_model->get_store_note_items($data['stn_info']['warehouse_id'],$data['stn_info']['stn_no']);
	    $data['warehouse_details']=$this->Warehouse_Model->get_warehouse_info($data['stn_info']['warehouse_id']);
	   
	    $this->load->view('models/store_notes_print',$data);
	}
	
	public function pos_storenote_list()
	{
	    $data['main_menu_name'] = $this->main_menu_name;
	    $data['sub_menu_name'] = $this->sub_menu_name;
	    $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
	    $this->load->view('store_delivery/store_notes',$data);
	}
	
		public function pos_view()
	{
	    $data['main_menu_name'] = $this->main_menu_name;
	    $data['sub_menu_name'] = $this->sub_menu_name;
	    
	    $stn_id = $this->uri->segment(3);
	    
	    $data['stn_info']=$this->store_notes_model->get_store_note_info($stn_id);
	    $data['stn_items']=$this->store_notes_model->get_store_note_items($data['stn_info']['warehouse_id'],$data['stn_info']['stn_no']);
	    $data['warehouse_details']=$this->Warehouse_Model->get_warehouse_info($data['stn_info']['warehouse_id']);
	    
	    /**
	    echo "<pre>";
	    print_r($data);
	    echo "</pre>";
	    */
	    $this->load->view('store_delivery/store_notes_view',$data);
	}
	
	function pos_list_stn(){
	    $start=$this->input->post('start');
    	$length=$this->input->post('length');
    	$search=$this->input->post('search');
	    $warehouse_id = $this->input->post('warehouse_id');
	    
	    $data = array();	
	    $totalData = $this->store_notes_model->get_all_store_notes("","",$search,$warehouse_id);
	    $totalFiltered = $totalData;
	    $stns   = $this->store_notes_model->get_all_store_notes($start,$length,$search,$warehouse_id);
	     //print_r($this->db->last_query());
	    	foreach ($stns as $row){
	    	    $nestedData=array(); 
	    	    $nestedData[] = $row['stn_date_time'];
	    	    $nestedData[] = $row['stn_code'];
	    	    $nestedData[] = $row['stn_no'];
	    	    
	    	    $nestedData[] = $row['sale_reference_no'];
	    	    $nestedData[] = $row['sale_total'];
	    	    
	    	    if($row['cus_id']!=1){
	    	     $nestedData[] = $row['cus_name'];
	    	     $nestedData[] = $row['cus_address'];
	    	    }else{
	    	       $nestedData[] = $row['cash_cus_name']; 
	    	        $nestedData[] = $row['address_input'];
	    	    }
	    	    $nestedData[] = $row['cus_phone']; 
	    	    if( $row['st_note_status']==1){
	    	       $nestedData[] = "<span class='btn btn-success'>Completed</span>"; 
	    	    }else{
	    	      $nestedData[] = "<span class='btn btn-warning'>Pending</span>";   
	    	    }
	    	    $nestedData[] = '<div class="btn-group text-left">
                                    <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                                    <ul role="menu" class="dropdown-menu pull-right">
                                    <li><a href="'.base_url().'store_notes/pos_view/'.$row['stn_id'].'"><i class="fa fa-file-text-o"></i> Store Note Details</a></li>
                                    <li><a onClick="fbs_click('.$row['stn_id'].')" data-toggle="modal" href="#" ><i class="fa fa-print"></i> Print STN</a></li>
							</ul></div>';
				$data[]=$nestedData;
	    	}
	    $json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	    echo json_encode($json_data); 
	}

}