<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Management extends CI_Controller {

    var $main_menu_name = "management";
	var $sub_menu_name = "";

	public function __construct()
	{
		parent::__construct();
		date_default_timezone_set("Asia/Colombo");
		$this->load->model('Warehouse_Model');
		$this->load->model('Common_Model');
		$this->load->model('Production_Estimate_Model');
		
		$this->load->model('User_Model');
		$this->load->model('Management_Model');
	}
	function index()
	{ 
		show_404();
	}
	 function pending_bulk_requste(){
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "pending_bulk_requste";
        $this->load->view('management/bulk_resuest_pending',$data);
	}
	 function pending_estimation(){
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = "pending_estimation";
        $this->load->view('management/estimation_pending_approval',$data);
	}
	public function get_pending_bulk_request($value = ''){
        $values         = $this->Management_Model->getPendingBulkRequest();
        $totalData     = 0;
        $totalFiltered = $totalData;
        $data          = array();
        if (!empty($values)) {
            foreach ($values as $products) {
                $row=array();
                $row[]               = $products->added_date_time;
                $row[]               = $products->brm_ref_no;
                $row[]               = $products->brm_manual_ref_no;
                $row[]               = $products->name;
                $row[]               = $products->user_first_name." ".$products->user_last_name;
                $row[]               = $products->brm_note;
                $actdes = '';
                $actdes = $actdes . '<div class="btn-group text-left">
                            <button data-toggle="dropdown" class="btn btn-default btn-xs  dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">
                            <li><a href="' . base_url('production_process/add_bulk_request_items') . '?id=' . $products->brm_id . '"><i class="fa fa-pencil-square-o"></i> Update Bulk Request</a></li>
                            <li><a style="cursor: pointer;" onclick="approval_requste('. $products->brm_id .')"><i class="glyphicon fa fa-check"></i> Approval</a></li>
                            <li><a style="cursor: pointer;" onclick="reject_requste('. $products->brm_id .')"><i class="glyphicon fa fa-ban"></i> Reject</a></li>
                            ';
                $row[]               = $actdes;
                $data[] = $row;
            }
            $output = array(
                'data' => $data,
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered)
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
	 function approval_bulk_requste(){
	     $this->load->model('Production_Process_Model');
	    $this->load->library('form_validation');
		$id=$this->input->post('id');
		$this->form_validation->set_rules('id', 'ID', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $data=array(
			'brm_approval_status'=>1,
			'approval_by'=>$this->session->userdata('ss_user_id'),
			'approval_date_time'=>date("Y-m-d H:i:s"),
		);	
         $result=$this->Production_Process_Model->update_bulk_request_master_table($id,$data);	   
          $st = array('status' =>1,'validation' =>'Updated');
          echo json_encode($st);
		}
	}
	function reject_bulk_requste(){
	    $this->load->library('form_validation');
		$id=$this->input->post('id');
		$this->form_validation->set_rules('id', 'ID', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $data=array(
			'brm_approval_status'=>2,
			'approval_by'=>$this->session->userdata('ss_user_id'),
			'approval_date_time'=>date("Y-m-d H:i:s"),
		);	
         $result=$this->Production_Process_Model->update_bulk_request_master_table($id,$data);	   
          $st = array('status' =>1,'validation' =>'Updated');
          echo json_encode($st);
		}
	}
	
	
		public function get_pending_cost_estimation($value = ''){
        $values         = $this->Management_Model->getPendingCostEstimation();
        $totalData     = 0;
        $totalFiltered = $totalData;
        $data          = array();
        if (!empty($values)) {
            foreach ($values as $products) {
                 $row=array();
                $row[]               = $products->pcem_date_time;
                $row[]               = $products->pcem_id_ref_no;
                $row[]               = $products->pcem_estimated_total_cost;
                $row[]               = $products->warehouse_name;
                $row[]               = $products->user_first_name;
                $row[]               = $products->pcem_note;
                $actdes = '';
                $actdes = $actdes . '<div class="btn-group text-left">
                            <button data-toggle="dropdown" class="btn btn-default btn-xs  dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                            <ul role="menu" class="dropdown-menu pull-right">
                            <li><a href="' . base_url('estimate/loadProductionEstimateDetails').'?id=' . $products->pcem_id . '"><i class="fa fa-info-circle"></i> Cost Estimate Details</a></li>
                            <li><a style="cursor: pointer;" onclick="approval_requste('. $products->pcem_id .')"><i class="glyphicon fa fa-check"></i> Approval</a></li>
                            <li><a style="cursor: pointer;" onclick="reject_requste('. $products->pcem_id .')"><i class="glyphicon fa fa-ban"></i> Reject</a></li>
                            ';
                $row[]               = $actdes;
                $data[] = $row;
            }
            $output = array(
                'data' => $data,
                "recordsTotal" => intval($totalData),
                "recordsFiltered" => intval($totalFiltered)
            );
            echo json_encode($output);
        } else {
            $output = array(
                'data' => ''
            );
            echo json_encode($output);
        }
    }
    
     function approval_cost_estimation(){
	    $this->load->library('form_validation');
		$id=$this->input->post('id');
		$this->form_validation->set_rules('id', 'ID', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $data=array(
			'pcem_approval_status'=>1,
			'pcem_approval_by'=>$this->session->userdata('ss_user_id'),
			'pcem_approval_on'=>date("Y-m-d H:i:s"),
		);	
         $result=$this->Production_Estimate_Model->runUpdateMaster($id,$data);	   
          $st = array('status' =>1,'validation' =>'Updated');
          echo json_encode($st);
		}
	}
	function reject_cost_estimation(){
	    $this->load->library('form_validation');
		$id=$this->input->post('id');
		$this->form_validation->set_rules('id', 'ID', 'required|xss_clean');
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
            $data=array(
			'pcem_approval_status'=>2,
			'pcem_approval_by'=>$this->session->userdata('ss_user_id'),
			'pcem_approval_on'=>date("Y-m-d H:i:s"),
		);	
         $result=$this->Production_Estimate_Model->runUpdateMaster($id,$data);	   
          $st = array('status' =>1,'validation' =>'Updated');
          echo json_encode($st);
		}
	}
	
	


}