<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Supplier_Payment_Process extends CI_Controller
{
    var $main_menu_name = "supplier_payment_process";
    var $sub_menu_name = "supplier_payment_process";
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Common_Model');
        $this->load->model('In_Type_Model');
        $this->load->model('Purchases_Model');
        $this->load->model('Warehouse_Model');
        $this->load->model('Bank_Model');
        $this->load->model('User_Model');
        $this->load->model('api/Supplier_Payment_Process_Model','Supplier_Payment_Process_Model');
    }
    public function index()
    {

        $data['main_menu_name'] = 'purchases';
        $data['sub_menu_name'] = 'Supplier_payment';
        $data['supplier'] = $this->Purchases_Model->get_supplier_list();
        $data['supplier_id'] = $this->input->get('sup_id');
        $data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
        $data['bank_list'] = $this->Bank_Model->get_all_bank_account();
        $data['user_list'] = $this->User_Model->get_all_cash_collector_users();
        $data['sales_list'] = $this->Supplier_Payment_Process_Model->get_grn_complete_info_by_customer_id($this->input->get('sup_id'));
        $this->load->view('suppier_payment/suppier_payment', $data);
    }


public function get_supplier_payments($value='')
    {
        if (isset($_SERVER['HTTP_ORIGIN'])) {
            // Decide if the origin in $_SERVER['HTTP_ORIGIN'] is one
            // you want to allow, and if so:
            header("Access-Control-Allow-Origin: {$_SERVER['HTTP_ORIGIN']}");
            header('Access-Control-Allow-Credentials: true');
            header('Access-Control-Max-Age: 86400');    // cache for 1 day
        }
            // Access-Control headers are received during OPTIONS requests
        if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {

            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_METHOD']))
                // may also be using PUT, PATCH, HEAD etc
                header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

            if (isset($_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']))
                header("Access-Control-Allow-Headers: {$_SERVER['HTTP_ACCESS_CONTROL_REQUEST_HEADERS']}");

            exit(0);
        }
	       //$values = $this->Supplier_Payment_Process_Model->get_suplier_payments();
	       //echo '<pre>',print_r($values); die();
	       $values = $this->Supplier_Payment_Process_Model->get_suplier_payments();
	       if(!empty($values)){
	           foreach($values as $value){
	               $purchase_payment_items = $this->Supplier_Payment_Process_Model->get_suplier_payment_items($value->pay_g_id);
	               if(!empty($purchase_payment_items)){
	                   $value->items = $purchase_payment_items;
	               }
	               $value->system_id = 'Sasada';
	           }
	       }
	      
            $data = array();
            $pay_st;
            if (!empty($values)) {
                
                $output = array('data' =>$values);
                echo json_encode($output);
            }else{
                $output = array('data' =>'');
                echo json_encode($output);
            }
       }


    public function get_supplier_paymentsdd()
    {

       $suppliers = $this->Supplier_Payment_Process_Model->get_supliers();
       $totalData = $this->Supplier_Payment_Process_Model->get_all_suplier_payment("", "", '');
       echo '<pre>',print_r($totalData); die();
        
    }



    public function get_list_supplier_payment($value = '')
    {
        $requestData = $_REQUEST;
        $start = $this->input->get('start');
        $length = $this->input->get('length');
        $search = $this->input->get('search');
        $totalData = $this->Supplier_Payment_Process_Model->get_all_suplier_payment("", "", $search);
        $values = $this->Supplier_Payment_Process_Model->get_all_suplier_payment($start, $length, $search);
        $totalFiltered = $totalData;
        $data = array();
        $pay_st;
        if (!empty($values)) {
            foreach ($values as $purchases) {

                $row = array();
                $y_des = 0;
                $print_url = base_url("cheque_process") . "?d=" . date('Y-m-d', strtotime($purchases->pay_g_date_time)) . "&n=" . $purchases->supp_company_name . "&a=" . $purchases->pay_amount . "&y=$y_des";
                $date = date_create($purchases->pay_g_date_time);
                $date_only = date_format($date, "Y-m-d");
                $row[] = $date_only;
                $row[] = $purchases->payment_system_ref_no;
                $row[] = $purchases->supp_company_name;
                $row[] = $purchases->ref_no . " / " . $purchases->cheque_no;
                $row[] = $purchases->p_type_name;
                $row[] = $purchases->bank_name;
                $row[] = $purchases->note;
                $row[] = number_format($purchases->pay_amount, 2, '.', ',');
                $row[] = '<div class="text-center"><div class="btn-group text-left">
                    <button data-toggle="dropdown" class="btn btn-default btn-xs btn-primary dropdown-toggle" type="button">Actions <span class="caret"></span></button>
                    <ul role="menu" class="dropdown-menu pull-right">
                    <!--<li><a href="#" onclick="cheque_print(' . $purchases->pay_g_id . ',' . $purchases->pay_g_id . ',' . $purchases->pay_g_id . ');return false;"><i class="fa fa-print"></i> Cheque Print</a></li>-->
                    
                    <li style="cursor:pointer"><a target="_blank" href="' . $print_url . '"  ><i class="fa fa-print"></i> Print Cheque</a></li>
                    <li><a href="' . base_url("supplier_payment_process/supplier_multiple_payment_details") . '?id=' . $purchases->pay_g_id . '"> <i class="fa fa-file-text-o"></i> Payment Details </a></li>
                    <li><a href="#" onclick="fbs_click(' . $purchases->pay_g_id . ');return false;"><i class="fa fa-print"></i> Recipt Print</a></li>
                    </ul></div>
                    </div>';
                $data[] = $row;
            }
            $output = array('data' => $data,    "recordsTotal"    => intval($totalData),     "recordsFiltered" => intval($totalFiltered),);
            echo json_encode($output);
        } else {
            $output = array('data' => '');
            echo json_encode($output);
        }
    }








    public function supplier_multiple_payment_print()
    {
        $smp_id                    = $this->input->get('id');
        $data['mp_details']        = $this->Supplier_Payment_Process_Model->get_suplier_payment_details_by_id($smp_id);
        $this->load->model('Cheque_Process_Model');
        $mp_details                = array();
        $data['mp_itm_list']       = $this->Supplier_Payment_Process_Model->get_suplier_payment_item_list_by_id($smp_id);
        $data['mp_itm_grn_return_list']       = array();
        $data['mp_itm_sup_ajes_list']       = array();
        $data['mp_sales_list']       = array();
        $data['warehouse_details'] = array();
        $this->load->view('suppier_payment/supplier_multiple_payment_print', $data);
    }

    public function supplier_multiple_payment_details()
    {
        $smp_id                    = $this->input->get('id');
        $data['main_menu_name'] = 'purchases';
        $data['sub_menu_name'] = 'list_supplier_payment';
        $data['mp_details']        = $this->Supplier_Payment_Process_Model->get_suplier_payment_details_by_id($smp_id);
        $this->load->model('Cheque_Process_Model');
        $mp_details                = array();
        $data['mp_itm_list']       = $this->Supplier_Payment_Process_Model->get_suplier_payment_item_list_by_id($smp_id);
        $data['mp_itm_grn_return_list']       = array();
        $data['mp_itm_sup_ajes_list']       = array();
        $data['mp_sales_list']       = array();
        $data['warehouse_details'] = array();
        $this->load->view('suppier_payment/supp_pay_details', $data);
    }
}
