<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');



class Dailly_Scheduled_Process extends CI_Controller {

    var $main_menu_name = "dailly_scheduled_process";
	var $sub_menu_name = "";

    public function __construct()
    {
        parent::__construct();
        date_default_timezone_set("Asia/Colombo");
        $this->load->model('country_model');
		$this->load->model('Common_Model');
		$this->load->model('Management_Model');
		$this->load->model('Manual_Function_Model');
		$this->load->model('Purchases_Model');
		$this->load->model('Sales_Model');
		$this->load->model('Sales_Return_Model');		
	}
	
	public function index()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;		
	}

	public function close_paid_invoices(){
		$values = $this->Manual_Function_Model->get_unpaid_sales();	
		 if (!empty($values)) {
            foreach ($values as $row) { 
					$sale_id=$row['sale_id'];
					$total_paid_amount=$this->Sales_Model->get_total_paid_by_sale_id($sale_id);		
					$return_tot=$this->Sales_Return_Model->get_relevant_return_by_sale_id($sale_id);		
					if(isset($return_tot['sl_rtn_total']))
						{
						$return_tot_amt=$return_tot['sl_rtn_total'];
						}
						else
						{
						$return_tot_amt=0;
						}
				
				 $sale_balance=$row['sale_total']-$return_tot_amt-$total_paid_amount;
				
				if($sale_balance<=0){
				$result=$this->Manual_Function_Model->close_sale($sale_id);	
				echo $row['sale_reference_no']." is Done <br>";
				}				
				}              
         }		
	}

	public function close_complete_multiple_payment()
	{
		$values = $this->Manual_Function_Model->get_uncomplte_multiple_payment();	
		if (!empty($values)) {
		   foreach ($values as $row) { 
				$id=$row['smp_id'];
				$sale_paid=$this->Manual_Function_Model->get_total_sale_paid_by_smp_id($id);		
				$return_paid=$this->Manual_Function_Model->get_total_cheque_return_paid_by_smp_id($id);			   
				$sale_balance=$row['smp_amount']-$return_paid-$sale_paid;
				if($sale_balance>0)
				{
					echo " overPayment ".$row['smp_amount']." ".$sale_balance." ( ".$row['payment_ref_no'].")<br>";
				}			   
			   if($sale_balance==0){
			   $result=$this->Manual_Function_Model->close_payment($id);	
			   echo $row['payment_ref_no']." is Done <br>";
			   }			   
			   }              
		}
	}



	public function reject_credit_facility_over_due_invoices()
	{
		$sale_list= $this->Manual_Function_Model->get_pending_sale_list();	
		$today		=date("Y-m-d");	
		$type="";
		foreach($sale_list as $row){
			$sale_id=$row['sale_id'];
			$customer_id=$row['customer_id'];			
			$due_date		=date("Y-m-d");	
			$reson="";
			if($row['invoice_type']==1){
			$sale_date		=date_create($row['sale_datetime']);
			$sale_date		= date_format($sale_date,"Y-m-d");
			$due_date 		= date('Y-m-d', strtotime($row['sale_datetime'] . ' +10 day'));
			$type="Cash";
			}
			if($row['invoice_type']==2){
				//$reson= $row['sale_reference_no']." invoice ".$sale_date." is due on ".$due_date." (reject by system )";
				$sale_date	= date_create($row['sale_datetime']);
				$sale_date 	= date_format($sale_date,"Y-m-d");
				$due_date 	= date('Y-m-d', strtotime($row['sale_datetime'] . ' +30 day'));
				$type="Credit";
			}
			if($due_date<=$today){

				$reson= $row['sale_reference_no']." invoice (".$type.") ".$sale_date." is due on ".$due_date." (reject by system )";
				$data = array(
					'cus_credit_status' => 3,
					'credit_rejected_by' => 0,
					'credit_rejected_date' => date('Y-m-d H:i:s'),
					'redit_rejected_reson' => $reson,
				);
				$response=$this->Management_Model->approval_credit_customer($customer_id,$data);
				echo $reson."<br>";	

			}
			else{continue;}


		}

	
		
		




	}


	



}