<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Bulk_Break extends CI_Controller
{
    var $main_menu_name = "products";
    var $sub_menu_name = "products";
    public function __construct()
    {
        parent::__construct();
        $this->load->model('category_models');
        $this->load->model('product_models');
        $this->load->model('common_model');
        $this->load->model('Sales_Model');
        $this->load->model('Transfer_Model');
        $this->load->model('Purchases_Model');
        $this->load->model('Product_Damage_Model');
        $this->load->model('Sales_Return_Model');
        $this->load->model('Customer_Order_Process_Model');
        $this->load->model('Product_Discount_Model');
		$this->load->model('Bulk_Break_Model');
		 
    }
    /*public function index()
    {
        $data['main_menu_name'] = $this->main_menu_name;
        $data['sub_menu_name']  = $this->sub_menu_name;
        $this->load->view('product/products', $data);
    }*/
	
	function process(){
		
		$product_id		=$this->input->post('product_id');
		$product_qty	=$this->input->post('product_qty');
		$product_cost	=$this->input->post('product_cost');
		$sub_product_id	=$this->input->post('sub_product_id');
		$sub_product_qty=$this->input->post('sub_product_qty');
		$wholesale_price=$this->input->post('wholesale_price');
		$retail_price	=$this->input->post('retail_price');
		$credit_price	=$this->input->post('credit_price');
		
		$user_warehouse_id = $this->session->userdata('ss_warehouse_id');
		$warehouse_qty = $this->warehouse_qty($product_id,$user_warehouse_id);
		$sub_product_cost	=	($product_cost * $product_qty)	/	$sub_product_qty;
		
		$bulkData = array(
			'mp_id' => $product_id,
			'warehouse_id' =>$user_warehouse_id,
			'mp_cost' => $product_cost,
			'mp_qty' => $product_qty,
			'sp_id' => $sub_product_id,
			'sp_cost' => $sub_product_cost,
			'sp_qty' => $sub_product_qty,
			'sp_hw_cash_price' => $retail_price,
			'sp_hw_credit_price' => $credit_price,
			'sp_hw_wholesale_price' => $wholesale_price
		);
		$result = $this->Bulk_Break_Model->save_bulk_break($bulkData);
		if($result){
			if ($this->Bulk_Break_Model->update_product($sub_product_id, $sub_product_cost, $retail_price,$credit_price, $wholesale_price)) {
                        $st = array(
                            'status' => 1,
                            'validation' => 'Done!'
                        );
                        echo json_encode($st);
			} else {
				$st = array(
					'status' => 0,
					'validation' => '500 Internal Server Error'
				);
				echo json_encode($st);
			}
		}else{
				$st = array(
					'status' => 0,
					'validation' => '500 Internal Server Error'
				);
				echo json_encode($st);
		}
	}
	function warehouse_qty($product_id,$warehouse_id){
			
				$transferd_qty       = $this->Transfer_Model->getTransferdQtyByWarehouseId($warehouse_id, $product_id);
                $transfer_reseve_qty = $this->Transfer_Model->getTransferResevedQtyByWarehouseId($warehouse_id, $product_id);
                $purchased_qty       = $this->Purchases_Model->getPurchasedQtyByWarehouseId($warehouse_id, $product_id);
                $product_damaged_qty = $this->Product_Damage_Model->getProductDamagedQtyByWarehouseId($warehouse_id, $product_id);
                $sales_return_qty    = $this->Sales_Return_Model->getSalesReturnQtyByWarehouseId($warehouse_id, $product_id);
                $issue_qty           = $this->Customer_Order_Process_Model->get_all_cus_isued_item($warehouse_id, $product_id);
                $return_qty          = $this->Customer_Order_Process_Model->get_all_cus_return_item($warehouse_id, $product_id);
				$mp       = $this->Bulk_Break_Model->getMpBreakQty($warehouse_id, $product_id);
				$sp		  = $this->Bulk_Break_Model->getSpBreakQty($warehouse_id, $product_id);
                $qty                 = $purchased_qty - $issue_qty + $return_qty - $product_damaged_qty + $transfer_reseve_qty - $transferd_qty - $mp + $sp;
		return $qty;	
	}
	function load_process($product_id){
		
		$data['product_details']    = $this->product_models->get_product_by_id($product_id);
		$user_warehouse_id = $this->session->userdata('ss_warehouse_id');
		$warehouse_qty = $this->warehouse_qty($product_id,$user_warehouse_id);
		$data['product_id'] = $product_id;
		$data['qty']		= $warehouse_qty;
		$data['warehouse_id'] = $user_warehouse_id;
		
		$this->load->view("models/bulk_break",$data);
	}
	function get_sub_products(){
        $str = $this->input->post('search_string');
		$main_product_id = $this->input->post('main_product_id');
		$result=$this->Bulk_Break_Model->sub_products_of($str,$main_product_id);
        echo json_encode($result);
    }
}