<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');



class Sales_Rep_Issue_Model extends CI_Model {

  

  private $tableName = 'sales_rep_issues';

  

  function __construct() 

  {

    /* Call the Model constructor */

    parent::__construct();

  }

  

  

  public function get_next_ref_no()

	{

	$this->db->select_max('sales_rep_issue_id');

	return $this->db->get('sales_rep_issues');	

	}

	

	 public function get_next_return_ref_no()

	{

	$this->db->select_max('sales_rep_issue_return_id');

	return $this->db->get('sales_rep_issues_return');	

	}

	

	

	public function get_product_suggestion($term)

	{

		$this->db->select('product'.'.*');

		$this->db->order_by("product_name", "asc");

		

		$this->db->where("product_name LIKE '%$term%' OR product_code LIKE '%$term%' OR product_oem_part_number LIKE '%$term%' OR product_part_no LIKE '%$term%'");

		 $this->db->limit(10, 0);

		$query = $this->db->get('product');

		return $query->result_array();

	

	

	}

	

	function get_sale_rep_invoice_item_qty($product_id,$sales_rep_id,$wharehouse_id,$sale_rep_issue_id)

	{

		

		$this->db->select_sum('quantity');

		$this->db->from('sale_items');

		$this->db->where("sale_items.product_id",$product_id);

		$this->db->where("sale_items.sales_rep_issue_id ",$sale_rep_issue_id);

		$query =$this->db->get();	

		return $query->row_array();	

		

	}

	

	function get_sales_rep_id($sale_rep_issue_id)

	{

		$this->db->select('sales_rep_id');

		$this->db->from('sales_rep_issues');

		$this->db->where("sales_rep_issue_id",$sale_rep_issue_id);

		$query =$this->db->get();	

		return $query->row_array();	

	}

	

	function get_warehouse_id_and_date($sale_rep_issue_id)

	{

		$this->db->select('wharehouse_id');

		$this->db->select('sales_rep_issue_date');

		$this->db->from('sales_rep_issues');

		$this->db->where("sales_rep_issue_id",$sale_rep_issue_id);

		$query =$this->db->get();	

		return $query->row_array();	

		

	}

	

	

  

  

  public function get_all_sales_rep_issue()

  {

	  $this->db->select('sales_rep_issues.*,user.user_first_name');

	  $this->db->from('sales_rep_issues');

	  $this->db->join('user','user.user_id=sales_rep_issues.sales_rep_id','left');

	  $this->db->order_by('sales_rep_issues.sales_rep_issue_id','desc');

	  $query=$this->db->get();

	 	return $query->result_array();	    

  

  }

  

  function save_sales_rep_issue($data,$sales_rep_issue_id)

	{

		

		

		

		

		if ($sales_rep_issue_id==0)

		{

			$this->db->insert($this->tableName,$data);	

		}else 

		{

			$this->db->where('sales_rep_issue_id',$sales_rep_issue_id);

			return $this->db->update($this->tableName,$data);

				

		

		}

	}	

	

	function save_sales_rep_issue_retrurn($data,$sales_rep_issue_id)

	{

		

		

		

		

		if ($sales_rep_issue_id)

		{

			$this->db->insert('sales_rep_issues_return',$data);

			/*$data2=array(			

			'status'=>"COMPLETED",				

			);

			$this->db->where('sales_rep_issue_id',$sales_rep_issue_id);

			$this->db->update($this->tableName,$data2);*/

				

		}else 

		{

			/*$this->db->where('sales_rep_issue_return_id',$sales_rep_issue_id);

			return $this->db->update('sales_rep_issues_return',$data);*/

				

		

		}

	}	

	

	

	function save_sales_rep_issue_retrurn_complte($sales_rep_issue_id)

	{	

			$data2=array(			

			'status'=>"COMPLETED",				

			);

			$this->db->where('sales_rep_issue_id',$sales_rep_issue_id);

			$this->db->update($this->tableName,$data2);

		

	}	

	

	

	

	function save_sales_rep_issue_retrurn_complete($sales_rep_issue_id)

	{

		

	}

	

	

	

	 function save_sales_rep_issue_return($data,$sales_rep_issue_id)

	{

				

		if ($sales_rep_issue_id==0)

		{

			$this->db->insert($this->tableName,$data);	

		}else 

		{

			$this->db->where('sales_rep_issue_return_id',$sales_rep_issue_id);

			return $this->db->update($this->tableName,$data);

				

		

		}

	}	

		

	

	

	public function delete_old_sales_rep_issue_items($sales_rep_issue_id)

	{

		$this->db->where('sales_rep_issue_id', $sales_rep_issue_id);

		$this->db->delete('sales_rep_issue_items');

	}

	

	public function delete_old_sales_rep_issue_items_return($sales_rep_issue_id)

	{

		$this->db->where('sales_rep_issue_return_id', $sales_rep_issue_id);

		$this->db->delete('sales_rep_issues_return_item');

	}

	

	

	

	function save_sales_rep_issue_item($data_item)

	{

			$this->db->insert('sales_rep_issue_items',$data_item);

	}	



	

	function save_sales_rep_issue_item_return($data_item)

	{

			$this->db->insert('sales_rep_issues_return_item',$data_item);

	}	



	

	

	function get_sales_detail_by_sales_rep_issue_id($sale_rep_issue_id)

	{	

		

		$this->db->select('*');

		$this->db->from('sales_rep_issues');

		$this->db->where('sales_rep_issue_id', $sale_rep_issue_id);

		$query=$this->db->get();

		return $query->row_array();

				

	}

	

	function get_sale_rep_issue_item_list_by_sale_id($sale_rep_issue_id)

	{

		$this->db->select('sales_rep_issue_items.product_id,sales_rep_issue_items.add_sales_excess_price,sales_rep_issue_items.add_sales_discount_price, sales_rep_issue_items.product_price,sales_rep_issue_items.product_cost, sales_rep_issue_items.salse_rep_issue_qty, product.product_name, product.product_code, product.product_part_no,product.product_oem_part_number');

		$this->db->from('sales_rep_issue_items');

		$this->db->join('product','sales_rep_issue_items.product_id = product.product_id','left');

		$this->db->where('sales_rep_issue_items.sales_rep_issue_id',$sale_rep_issue_id);

		$query = $this->db->get();

		return $query->result_array();                                                                  

	}

  



}