<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Brands extends CI_Controller {

    var $main_menu_name = "products";
	var $sub_menu_name = "brands";

    public function __construct()
     {
            parent::__construct();
            $this->load->model('brands_model');
			$this->load->model('Common_Model');
			
     }

    public function index()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
		$this->load->view('brands',$data);
	}
	
	function get_list_brand($value='')
	{

		$search_key=$this->input->get('search');
		$search_key_val=$search_key['value'];
		$start=$this->input->get('start');
		$length=$this->input->get('length');
		$totalData = 0;
		
	    $values = $this->brands_model->get_brands($start,$length,$search_key_val);			
		$value_count = $this->brands_model->get_brands('','','');

		
		$totalData = $value_count;
		$totalFiltered = $value_count; 
		
		 
	        $data = array();

	        if (!empty($values)) {
	            foreach ($values as $brands) {
				$k ='';
				$btnEdit = 
				'<a onclick="brand_update_btn('.$brands->brand_id.')" data-toggle="modal" href="#" class="btn btn-xs btn-blue tooltips" data-placement="top" data-original-title="Edit customers">
					<i class="glyphicon fa fa-edit"></i>
				</a>';
				
				$btnEnable =
				'<a class="btn btn-xs btn-green tooltips" data-placement="top" data-original-title="Disable brand" onclick="enableBrand('.$brands->brand_id.')">
					<i class="glyphicon fa fa-check"></i>
				</a>';
				$btnDisable = 
				'<a class="btn btn-xs btn-warning tooltips" data-placement="top" data-original-title="Disable brand" onclick="disableBrand('.$brands->brand_id.')">
					<i class="glyphicon fa fa-minus-circle"></i>
				</a>';
				$btnDelete =
				'<a class="btn btn-xs btn-bricky tooltips" data-placement="top" data-original-title="Delete brand" onclick="deleteBrand('.$brands->brand_id.')">
					<i class="glyphicon fa fa-trash-o"></i>
				</a>';
	          
			    if ($brands->status == 0) {
					$k = "btn-danger";$m = "fa-minus-circle";
					$btnEnable = '';
					} else {
						$k = "btn-green";$m = "fa-check";
						$btnDisable = '';	
					}
              	$retVal = (empty($brands->sub_cat_name)) ? "--:--" : $brands->sub_cat_name ;
              
	            $row = array();
				
				
				
                  
//				$row[] = '<div style="margin-bottom: 0px; width: 50px; height: 50px;" class="fileupload-new thumbnail"><img alt="" src="'.asset_url()."uploads/thumbs/".$brands->brand_thumb.'"></div>';
                $row[] =$brands->brand_code;                
	            $row[] = $brands->brand_name;
	            $actdes='';
	                $actdes =$actdes. '<div class="btn-group text-left">'.$btnEdit.$btnEnable.$btnDisable.$btnDelete.'</div>';
							
					$row[] =$actdes;	
						
	                $data[] = $row;
				
	            }

	            $output = array('data' =>$data,"recordsTotal"    => intval( $totalData ),  
				"recordsFiltered" => intval( $totalFiltered ));
	            echo json_encode($output);
	        }else{
	            $output = array('data' =>'');
	            echo json_encode($output);

	        }
	   }
    
	function price_filter($amount='')
	{
		$s = explode("Rs.",$amount);
		return str_replace(',', '', $s[1]);
	}

	
	function create_brand()
	{
        $brand_id = '';
        if (isset($_GET['brand_id'])) {
			$brand_id=$_GET['brand_id'];
		}
		else {
			$cus_id='';
		}
		if($brand_id){
			$data['brand_id']=$brand_id;
			$data['type']='E';
			$data['pageName']='UPDATE BRAND';
			$data['btnText']='Update Brand';
			$data['brand']= $this->brands_model->get_brand_by_id($brand_id);	
		}
		else {
			$data['brand_id']='';
			$data['type']='A';
			$data['pageName']='ADD BRAND';
			$data['btnText']='Add Brand';
			$data['customer']=array();
		}
        $this->load->view('models/create_brand',$data);	
	}
	function save_brand()
		{
			$this->load->library('form_validation'); //form validation lib
			$this->form_validation->set_rules('brand_name', 'Brand Name', 'required');
				//if($this->input->post('brand_id'))
				//$this->form_validation->set_rules('brand_code', 'Brand Code', 'required|is_unique[master_brand.brand_code]');
	
			if ($this->form_validation->run() == FALSE)
			{
			   $st = array('status' =>0,'validation' => validation_errors());
			   echo json_encode($st);
			}
			else
			{
				$brand_id				= $this->input->post('brand_id');
				$brand_name 			= $this->input->post('brand_name');
				$brand_code 			= '';//$this->input->post('brand_code');
				
			$last_id = $this->brands_model->save_brand($brand_id,$brand_name,$brand_code);
				if ($last_id) {
				
					   $st = array('status' =>1,'validation' =>'Done!','last_id'=>"PD".sprintf("%05d",$last_id+1));
					   echo json_encode($st);
				
				} else {
				
					   $st = array('status' =>0,'validation' =>'error occurred please contact your system administrator');
					   echo json_encode($st);
				}
				
			}
	
		}


  function delete_brand($brand_id='')
  {
    $d = $this->brands_model->delete_brand($this->input->post('brand_id'));
    if ($d) {
      $e = array('status' =>1);
      echo json_encode($e);
    } else {
      $e = array('status' =>0,'validation'=>'This brand is already linked. You cannot delete it.');
      echo json_encode($e);
    }
    
  }
		function getBrand()
    {
        $str    = $this->input->get('search_string');
        $result = $this->brands_model->get_search_brand($str);
        echo json_encode($result);
    }

}