<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Sys_Settings extends CI_Controller {

    var $main_menu_name = "settings";
	var $sub_menu_name = "sys_settings";
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('Sys_Settings_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Common_Model');
		
	}

	public function index()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
        $this->load->view('system_settings/system_settings',$data);
	}
	
	

	
	



	public function list_settings()
	{
	$requestData= $_REQUEST;
	
	$columns = array( 
		0 =>'system_setting_description', 
	);
	
	$data = array();
	$vehicle = $this->Sys_Settings_Model->get_all_sys_setting();
	$totalData = count($vehicle);
	$totalFiltered = $totalData;  
	
	foreach ($vehicle as $row){
		$nestedData=array(); 
		$nestedData[] = $row['system_setting_description'];
	
		$actionTxtDisble='';
		$actionTxtEnable='';
		$actionTxtUpdate='';
		$actionTxtDelete='';
		$actionTxtUpdate='';//'<a onClick="click_vehicle_update_btn('.$row['sys_setting_id'].')" data-toggle="modal" href="#" class="btn btn-xs btn-blue tooltips" data-placement="top" data-original-title="Edit suppliers"><i class="glyphicon fa fa-edit"></i></a> &nbsp;';
		if($row['system_setting_status']==1){
			$actionTxtDisble = '<a class="btn btn-xs btn-green tooltips" data-placement="top" data-original-title="Disable supplier" onClick="disableUnitData('.$row['sys_setting_id'].')"><i class="glyphicon fa fa-check"></i></a> &nbsp;';
	}
		if($row['system_setting_status']==0){
			$actionTxtEnable = '<a class="btn btn-xs btn-warning tooltips" data-placement="top" data-original-title="Disable supplier" onClick="enableUnitData('.$row['sys_setting_id'].')"><i class="glyphicon fa fa-minus-circle"></i></a> &nbsp;';
	}
		$actionTxtDelete='';//'<a class="btn btn-xs btn-bricky tooltips" data-placement="top" data-original-title="Delete supplier" onClick="deleteUnitData('.$row['sys_setting_id'].')">
							//								<i class="glyphicon fa fa-trash-o"></i></a>';
	
	$nestedData[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtDelete;
	$data[] = $nestedData;
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data); 
	}


	function delete_setting() {
		$vehicle_id	= $this->input->post('vehicle_id');
		$this->Sys_Settings_Model->delete_sys_setting($vehicle_id);
        if ($vehicle_id) {
        	echo json_encode(array('id'=>$vehicle_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
	
	function disable_setting() {
		$vehicle_id	= $this->input->post('vehicle_id');
		$this->Sys_Settings_Model->disable_sys_setting($vehicle_id);
        if ($vehicle_id) {
        	echo json_encode(array('id'=>$vehicle_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
	
	function enable_setting() {
		$vehicle_id	= $this->input->post('vehicle_id');
		$this->Sys_Settings_Model->enable_sys_setting($vehicle_id);
        if ($vehicle_id) {
        	echo json_encode(array('id'=>$vehicle_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
}