<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
   
class Core_Estimate extends CI_Controller
{
    var $main_menu_name = "production_estimate";
    var $sub_menu_name = "production_estimate";
    private $main_model;
   
    public function __construct()
    {
        parent::__construct();
        date_default_timezone_set("Asia/Colombo");
        $this->load->model('Common_Model');
        $this->load->model('Production_Estimate_Model');
        $this->main_model=new Production_Estimate_Model();
    }
    public function index()
    {
       show_404();
    }
    //standard function
     protected function cleanAndValidateNumber($id){
        $this->load->helper("security");
        $recode_id = $this->security->xss_clean($id); 
       
        if($recode_id>=0&&$recode_id<999999){
            return $recode_id;
        }else{
            echo "invalid Number ";
            exit();
            return false;
        }
    }
    protected function cleanAndValidateText($text){
        $this->load->helper("security");
        $text = $this->security->xss_clean($text); 
        $text= preg_replace('/[^A-Za-z0-9\-]/', '', $text);
        return substr($text, 0, 255);
    }
    protected function cleanAndValidateArray($data){
        //$this->load->helper("security");
        //$data = $this->security->xss_clean($data); 
        return $data;
    }
     protected function getClientSideDataTableParameters(){
        $start          = $this->input->get('start');
        $length         = $this->input->get('length');
        $search_key     = $this->input->get('search');
        $search_key_val = $search_key['value'];
        $data=array();
        $data['start']=$this->cleanAndValidateNumber($start);
        $data['length']=$this->cleanAndValidateNumber($length);
        $data['search_key_val']=$this->cleanAndValidateText($search_key['value']);
        $data['custom_condition']=array();
        return $data;
    }
     protected function getClientSideBasicDataTableParameters(){
        $id = $this->getId();
        $data=array();
        $data['id']=$this->cleanAndValidateNumber($id);
        $data['custom_condition']=array();
        return $data;
    }
     protected function getId(){
        $id = $this->input->get('id');
        if($id){
            return $this->cleanAndValidateNumber($id);
        }else{
            $id = $this->input->post('id'); 
            return $this->cleanAndValidateNumber($id);
        }
    }
    protected function executeSaveMasterTable($data){
        return $this->main_model->runSaveMaster($data);
    }
    protected function executeSaveItemTable($data){
        return $this->main_model->runSaveItems($data);
    }
    protected function executeSaveSubItemTable($data){
        return $this->main_model->runSaveSubItems($data);
    }
    protected function executeUpdateMasterTable($id,$data){
        return $this->main_model->runUpdateMaster($id,$data);
    }
    protected function executeUpdateItemTable($id,$data){
        return $this->main_model->runUpdateItems($id,$data);
    }
    protected function executeUpdateSubItemTable($id,$data){
        return $this->main_model->runUpdateSubItems($id,$data);
    }
    protected function executeDeleteMasterTable($id){
        return $this->main_model->runDeleteMaster($id);
    }
    protected function executeDeleteItemTable($id){
        return $this->main_model->runDeleteItems($id);
    }
    protected function executeDeleteSubIteTable($id){
        return $this->main_model->runDeleteSubItems($id);
    }
    protected function executeSelectMasterTable($id){
        return $this->main_model->runSelectMaster($id);
    }
    protected function executeSelectItemTable($id){
        return $this->main_model->runSelectItems($id);
    }
    protected function executeSelectSubItemsTable($id){
        return $this->main_model->runSelectSubItems($id);
    }
    //customizeble functions 
    
    
     protected function updateRequestMasterTable($id,$data){
        return $this->main_model->loadUpdateRequsteMaster($id,$data);
    }
    
     protected function getUpdatePendingEstimateListForBasicDataTable($param_data){
        $values    = $this->main_model->loadUpdatePendingEstimate($param_data['id'],$param_data['custom_condition']);
        $return_data=array();
        $return_data['values']=$values;
        $return_data['value_count']=count($values);
        return $return_data;
    }
    protected function setEstimateBasicDataUsingMasterID($id,$data){
        $recode_id=$this->cleanAndValidateNumber($id);
        $data['details'] =$this->main_model->loadGetEstimateAllDetails($recode_id);
        return $data;
    }
     protected function setEstimateBasicDataUsingItemID($id,$data){
        $recode_id=$this->cleanAndValidateNumber($id);
        $data['item_list'] =$this->main_model->loadGetEstimateItemAllDetails($recode_id);
        return $data;
    }
     protected function setEstimateBasicDataUsingSubItemID($id,$data){
        $recode_id=$this->cleanAndValidateNumber($id);
        $data['sub_item_list'] =$this->main_model->loadGetEstimateSubItemAllDetails($recode_id);
        return $data;
    }
    protected function getPendingEstimateListForBasicDataTableOnServerSide($param_data){
        $values         = $this->main_model->loadPendingEstimateListServerSide($param_data['start'], $param_data['length'], $param_data['search_key_val'],$param_data['custom_condition']);
        if ($param_data['search_key_val']) {
            $value_count  = $this->main_model->loadPendingEstimateListServerSide('', '', $param_data['search_key_val'],$param_data['custom_condition']);
        }else{
            $value_count    = $this->main_model->loadPendingEstimateListServerSide('', '', '',$param_data['custom_condition']);
        }
        $return_data=array();
        $return_data['values']=$values;
        $return_data['value_count']=$value_count;
        return $return_data;
    }
    protected function setApprovedRequestBasicDataUsingMasterID($id,$data){
        $recode_id=$this->cleanAndValidateNumber($id);
        $data['details'] =$this->main_model->loadGetRequestAllDetails($recode_id);
        return $data;
    }
     protected function getApprovedRequestListForBasicDataTableOnServerSide($param_data){
        $values         = $this->main_model->loadGetApprovedRequestListServerSide($param_data['start'], $param_data['length'], $param_data['search_key_val'],$param_data['custom_condition']);
        if ($param_data['search_key_val']) {
            $value_count  = $this->main_model->loadGetApprovedRequestListServerSide('', '', $param_data['search_key_val'],$param_data['custom_condition']);
        }else{
            $value_count    = $this->main_model->loadGetApprovedRequestListServerSide('', '', '',$param_data['custom_condition']);
        }
        $return_data=array();
        $return_data['values']=$values;
        $return_data['value_count']=$value_count;
        return $return_data;
    }
    protected function getCompletedEstimateListForBasicDataTableOnServerSide($param_data){
        $values         = $this->main_model->loadComplededEstimateListServerSide($param_data['start'], $param_data['length'], $param_data['search_key_val'],$param_data['custom_condition']);
        if ($param_data['search_key_val']) {
            $value_count  = $this->main_model->loadComplededEstimateListServerSide('', '', $param_data['search_key_val'],$param_data['custom_condition']);
        }else{
            $value_count    = $this->main_model->loadComplededEstimateListServerSide('', '', '',$param_data['custom_condition']);
        }
        $return_data=array();
        $return_data['values']=$values;
        $return_data['value_count']=$value_count;
        return $return_data;
    }
    //update in 2022-06-22
    protected function getUpdateEstimatedItemForBasicDataTable($param_data){
        $values    = $this->main_model->getEstimatedItem($param_data['id'],$param_data['custom_condition']);
        $return_data=array();
        $return_data['values']=$values;
        $return_data['value_count']=count($values);
        return $return_data;
    }
    
    
    
    
    
    

   
  
}