<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
class Stock_Counter_Model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }
    
    //product full_stock_balance start--------------------------------------------------------------------------------
    function get_stock_balance($warehouse_id='',$product_id){
        $grn_total= $this->get_grn_qty($warehouse_id,$product_id);
        $sale_total= 0;//$this->get_sale_qty($warehouse_id,$product_id);
        $sale_return_total= 0;//$this->get_sale_return_qty($warehouse_id,$product_id);
        $damage_total= $this->get_damage_qty($warehouse_id,$product_id);
        $grn_return_total= $this->get_grn_return_qty($warehouse_id,$product_id);
        $product_balance=(($grn_total-$grn_return_total)-$damage_total)-($sale_total-$sale_return_total);
        $temp_balance= round($product_balance,3);
        if($temp_balance==(-0)){
            return 0;
        }else{
            return $temp_balance;
        }
    }
    function get_grn_qty($warehouse_id='',$product_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('purchase_items p');
        $this->db->where('p.product_id', $product_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    function get_sale_qty($warehouse_id='',$product_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('hw_sale_items p');
        $this->db->where('p.product_id', $product_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    function get_sale_return_qty($warehouse_id='',$product_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('hw_sales_return_items p');
        $this->db->where('p.product_id', $product_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
            
        }
    }
    function get_damage_qty($warehouse_id='',$product_id)
    {
        $this->db->select_sum('p.pdmgitm_quantity');
        $this->db->from('product_damage_item p');
        $this->db->where('p.product_id', $product_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['pdmgitm_quantity']))
        {
            return $result['pdmgitm_quantity'];
        }else{
       return 0;
        }
    }
     function get_grn_return_qty($warehouse_id='',$product_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('purchase_return_items p');
        $this->db->where('p.product_id', $product_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
     function get_production_issued_total_qty($warehouse_id='',$product_id){
        $this->db->select_sum('b.psi_item_qty');
        $this->db->from('production_stock_issue b');
        $this->db->where("b.psi_item_id",$product_id);
         if($warehouse_id){
          $this->db->where('b.psi_wrehouse_id', $warehouse_id);
        }
        $query = $this->db->get();
        $result= $query->row_array();
        if(isset($result['psi_item_qty'])){
          return $result['psi_item_qty'];  
        }else{
            return 0;
        }
    }
    //product full_stock_balance end----------------------------------------------------------------------------------------------
    
    
    //batch_stock balance start------------------------------------------------------------------------------------------------------
      function get_stock_balance_batch($warehouse_id='',$product_id,$batch_id){
        $grn_total= $this->get_batch_grn_qty($warehouse_id,$product_id,$batch_id);
        $sale_total= 0;//$this->get_batch_sale_qty($warehouse_id,$product_id,$batch_id);
        $sale_return_total= 0;//$this->get_batch_sale_return_qty($warehouse_id,$product_id,$batch_id);
        $adjesment_total= $this->get_batch_adjesment_qty($warehouse_id,$product_id,$batch_id);
        $grn_return_total= $this->get_batch_grn_return_qty($warehouse_id,$product_id,$batch_id);
        $production_issue= $this->get_production_issued_qty($warehouse_id,$product_id,$batch_id);
        
        $product_balance=($grn_total-$grn_return_total)-($sale_total-$sale_return_total)-($production_issue)+$adjesment_total;
        $temp_balance= round($product_balance,3);
        if($temp_balance==(-0)){
            return 0;
        }else{
            return $temp_balance;
        }
    }
    function get_batch_grn_qty($warehouse_id='',$product_id,$batch_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('btatch_prroduct_grn bg');
        $this->db->join('purchase_items p','p.id=bg.grn_item_id','inner');
         if($warehouse_id){
          $this->db->join('purchases pm','pm.id=p.purchase_id','inner');
          $this->db->where('pm.warehouse_id', $warehouse_id);
        }
        //$this->db->where('p.product_id', $product_id);
        $this->db->where('bg.batch_id', $batch_id);
        $this->db->group_by('p.product_id');
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    function get_batch_sale_qty($warehouse_id='',$product_id,$batch_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('hw_sale_items p');
        $this->db->where('p.product_id', $product_id);
        $this->db->where('p.batch_id', $batch_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    
     function get_batch_sale_return_qty($warehouse_id='',$product_id,$batch_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('hw_sales_return_items p');
        $this->db->where('p.product_id', $product_id);
        $this->db->where('p.batch_id', $batch_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    
     function get_batch_adjesment_qty($warehouse_id='',$product_id,$batch_id)
    {
        $this->db->select_sum('p.batch_qty');
        $this->db->from('batch_stock_adjesment p');
        $this->db->where('p.product_id', $product_id);
        $this->db->where('p.batch_id', $batch_id);
        if($warehouse_id){
             $this->db->where('p.warehouse_id', $warehouse_id);
        }
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['batch_qty']))
        {
            return $result['batch_qty'];
        }else{
       return 0;
        }
    }
     function get_batch_grn_return_qty($warehouse_id='',$product_id,$batch_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('purchase_return_items p');
         if($warehouse_id){
          $this->db->join('purchase_return pr','pr.pur_return_id=p.pur_return_id','inner');
          $this->db->where('pr.warehouse_id', $warehouse_id);
        }
        $this->db->where('p.product_id', $product_id);
        $this->db->where('p.batch_id', $batch_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    
    function get_production_issued_qty($warehouse_id='',$product_id,$batch_id){
        $this->db->select_sum('b.psi_item_qty');
        $this->db->from('production_stock_issue b');
        $this->db->where("b.psi_item_id",$product_id);
        $this->db->where("b.batch_id",$batch_id);
         if($warehouse_id){
          $this->db->where('b.psi_wrehouse_id', $warehouse_id);
        }
        $query = $this->db->get();
        $result= $query->row_array();
        if(isset($result['psi_item_qty'])){
          return $result['psi_item_qty'];  
        }else{
            return 0;
        }
    }
     //product batch_stock balance end-------------------------------------------------------------------------------
     
     //product batch purcheses balance stsrt ------------------------------------------------------------------------
     
     function get_purchased_stock_balance($product_id,$grn_id){
        $grn_total= $this->get_purchased_grn_qty($product_id,$grn_id);
        $grn_return_total= $this->get_purchased_return_grn_qty_total($product_id,$grn_id);
        $product_balance=$grn_total-$grn_return_total;
        return $product_balance;
    }
     function get_purchased_grn_qty($product_id,$grn_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('purchase_items p');
        $this->db->where('p.product_id', $product_id);
        $this->db->where('p.id', $grn_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
    function get_purchased_return_grn_qty_total($product_id,$grn_id)
    {
        $this->db->select_sum('p.quantity');
        $this->db->from('purchase_return_items p');
        $this->db->where('p.product_id', $product_id);
        $this->db->where('p.grn_item_id', $grn_id);
        $query = $this->db->get();
        $result=$query->row_array();
        if(isset($result['quantity']))
        {
            return $result['quantity'];
        }else{
       return 0;
        }
    }
     
     
     
     //product batch purcheses balance end ------------------------------------------------------------------------
   
}