<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');



class Lot_Process_Model extends CI_Model {  

  private $master_tableName = 'lot_order_master';
  private $master_primary_key = 'lot_master_id';  
  private $item_tableName = 'lot_order_items';
  private $item_primary_key = 'lot_order_item_id';  

  function __construct() 

  {
	 /* Call the Model constructor */
    parent::__construct();
  }	

	public function get_product_suggestion($term)
	{
		 $query = $this->db->query("SELECT * FROM `product` WHERE `product_status` = 1 AND `product_code` LIKE '%$term%' OR `product_name` LIKE '%$term%' LIMIT 15");
		return $query->result_array();
	}
	
 function insert_update_master_table($data,$id,$master_primary_key='')
	{
		if ($id==0)
		{
		$this->db->insert($this->master_tableName,$data);	
		}
		else 
		{
		$this->db->where($master_primary_key,$id);
		return $this->db->update($this->master_tableName,$data);
		}
	}
	
	 function insert_update_item_table($data,$id,$item_primary_key='')
	{
		if ($id=='')
		{
		return $this->db->insert($this->item_tableName,$data);	
		}else{
		$this->db->where($item_primary_key,$id);
		return $this->db->update($this->item_tableName,$data);
		}
	}	
	
	public function get_lot_order_master_details($order_id)
	{
	  $this->db->select($this->master_tableName.'.*,u.user_first_name,w.name,w.address,w.phone,w.email');
	  $this->db->from($this->master_tableName);
	  $this->db->join('user u','u.user_id='.$this->master_tableName.'.order_rep_id','left');
	  $this->db->join('warehouses w','w.id='.$this->master_tableName.'.wharehouse_id','left');
	  $this->db->join('routes r','r.route_id='.$this->master_tableName.'.route_id','left');
	  $this->db->where($this->master_tableName.'.lot_master_id',$order_id);
	  $query=$this->db->get();
	  return $query->row_array();	
	}
  
  function get_lot_order_item_details($order_id)
	{
		$this->db->select('so.product_id,so.add_sales_excess_price,so.add_sales_discount_price, so.product_price,so.product_cost, so.order_qty,so.after_discount_added_price,so.total_price,so.total_cost,so.issue_qty');
		$this->db->select('p.product_name, p.product_code, p.product_part_no,p.product_oem_part_number');
		$this->db->from('lot_order_items so');
		$this->db->join('product p','so.product_id = p.product_id','left');
		$this->db->where('so.lot_order_master_id',$order_id);
		$query = $this->db->get();
		return $query->result_array();
	}
	
	 public function get_lot_order_master_list()
  {
	  $this->db->select($this->master_tableName.'.*,u.user_first_name,w.name,w.address,w.phone,w.email,r.route_name');
	  $this->db->from($this->master_tableName);
	  $this->db->join('user u','u.user_id='.$this->master_tableName.'.order_rep_id','left');
	  $this->db->join('warehouses w','w.id='.$this->master_tableName.'.wharehouse_id','left');
	  $this->db->join('routes r','r.route_id='.$this->master_tableName.'.route_id','left');
	  $this->db->where($this->master_tableName.'.status',0);
	  $query=$this->db->get();
	  return $query->result_array();	
  }
	
	
	 public function get_lot_order_master_loaded_list()
  {
	  $this->db->select($this->master_tableName.'.*,u.user_first_name,w.name,w.address,w.phone,w.email,r.route_name,customer.cus_name');
	  $this->db->from($this->master_tableName);
	  $this->db->join('user u','u.user_id='.$this->master_tableName.'.order_rep_id','left');
	  $this->db->join('warehouses w','w.id='.$this->master_tableName.'.wharehouse_id','left');
	  $this->db->join('routes r','r.route_id='.$this->master_tableName.'.route_id','left');
	  $this->db->join('customer','customer.cus_id = '.$this->master_tableName.'.customer_id');
	  $this->db->where($this->master_tableName.'.status',1);
	  $query=$this->db->get();
	  return $query->result_array();	
  }

	function get_delivary_customers($order_id)
	{
		$this->db->select('customer_id,cus_name,cus_phone,cus_address,lot_master_id,lot_order_date,route_name,invoiced_status');
		$this->db->join('customer','customer.cus_id= lot_order_master.customer_id','left');
		$this->db->join('routes','customer.route_id= routes.route_id','left');
		$this->db->from('lot_order_master');
		$this->db->order_by("customer.route_id", "desc");
		$this->db->where('delivery_id',$order_id);
		$query = $this->db->get();
		return $query->result_array();
	}
	function get_customer_details_by_cus_id($order_id)
	{
		$this->db->select('cus_id,cus_name,cus_phone,cus_address');
		$this->db->from('customer');
		$this->db->where('cus_id',$order_id);
		$query = $this->db->get();
		return $query->result_array();
	}
}