<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Brands_Model extends CI_Model {

public function __construct()
   {
      parent::__construct();

   }
   function save_brand($brand_id,$brand_name,$brand_code){
    $data = array(
		   'brand_name'         	=> $brand_name
    	);
	if($brand_id){
		
		$this->db->where('brand_id', $brand_id);
		$this->db->update('master_brand', $data);
		return 1;
	}else
	if($this->db->insert('master_brand', $data)){
		$lst = $this->db->insert_id();
		$result = $this->update_brand_code($lst);
		return $result;
	}

     else

     {

       return false;

     }

   }

   public function update_brand_code($brand_id='')
   {
      $data = array(
                     'brand_code' => "BR".sprintf("%05d",$brand_id)
                  );

      $this->db->where('brand_id', $brand_id);
      $this->db->update('master_brand', $data); 
      return $brand_id;
   }

   function get_brands($start,$length,$search_key_val)
   {
	   
     $this->db->select('*');
     $this->db->from('master_brand p');
     if($search_key_val){
         $this->db->where("p.brand_name LIKE '%$search_key_val%' OR p.brand_code LIKE '%$search_key_val%'");
     }
	 $this->db->order_by("p.status", "desc");
     $this->db->order_by("p.brand_name", "asc");
	 
     
	 if($start!='' && $length!=''){
         $this->db->limit($length,$start);
		 $query = $this->db->get();
		 if($query->num_rows() >0)
     		{
      	 	return $query->result();
     		}
     		else
     		{
      	 	return false;
     		}
		}
		else
		{
			$query = $this->db->get();
			if($query->num_rows() >0)
     		{
      	 	return $query->num_rows();
     		}
     		else
     		{
      	 	return false;
     		}
			
		}
   }
	function selectBrand(){
     $this->db->select('*');
     $this->db->from('master_brand');
	 $this->db->where("brand_status","1");
	 $this->db->order_by("p.brand_name", "asc");
	 $query = $this->db->get();  
	 //echo $this->db->last_query();
     if($query->num_rows() >0)
     {
       return $query->result_array();
     }
     else
     {
       return false;
     }
   }
     function getProductsProduCodePrint($cat_id=0,$sub_cat_id=0)
   {
     $this->db->select('p.* , c.cat_name , s.sub_cat_name, u.unit_name');
     $this->db->from('master_brand p');
	   $this->db->join('brand_category c', 'c.cat_id = p.cat_id', 'left');   
	   $this->db->join('brand_sub_category s', 's.sub_cat_id = p.sub_cat_id', 'left'); 
	   $this->db->join('mstr_unit u', 'u.unit_id = p.brand_unit', 'left'); 
	   if($cat_id){
		   $this->db->where("p.cat_id","$cat_id");
	   }
	    if($sub_cat_id){
		   $this->db->where("p.sub_cat_id","$sub_cat_id");
	   }
	   $this->db->order_by("p.brand_id", "asc");
	   $query = $this->db->get();  
	  //echo $this->db->last_query();
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       return false;
     }
   }

   function getProductsForReport_del($wherehouse_id='',$cat_srh='')
   {
	 
    // $this->db->select("p.* , SUM(IF(ft.fi_type_id ='sale',ft.fi_qty,0)) AS sold_qty");
    // $this->db->from('master_brand p');
	// $this->db->join("fi_table ft", "ft.fi_item_id = p.brand_id AND ft.fi_type_id ='sale'", "left");
	// $this->db->group_by("p.brand_id"); 
	// $this->db->order_by("p.added_time", "desc");
	$query=$this->db->query("SELECT p.*,pc.cat_name,psc.sub_cat_name, SUM(IF(ft.fi_type_id ='sale', ft.fi_qty, 0)) AS sold_qty, SUM(IF(ft.fi_type_id ='grn', ft.fi_qty, 0)) AS purchased_qty FROM master_brand p LEFT JOIN fi_table ft ON ft.fi_item_id = p.brand_id AND (ft.fi_type_id ='sale' OR ft.fi_type_id ='grn') LEFT JOIN brand_category pc ON pc.cat_id = p.cat_id
	LEFT JOIN brand_sub_category psc ON psc.sub_cat_id = p.sub_cat_id

	WHERE pc.cat_id!='' GROUP BY p.brand_id  ORDER BY p.added_time desc");
	// echo $this->db->last_query();
	// $query = $this->db->get();  
	 //echo $this->db->last_query();
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       return false;
     }
   }
   
  
  
     function getProductsForReport($wherehouse_id='',$cat_srh='')
   {
	 
     $this->db->select("p.*,pc.cat_name,psc.sub_cat_name");
     $this->db->from('master_brand p');
	 $this->db->join("brand_category pc", "pc.cat_id = p.cat_id", "left");
	  $this->db->join("brand_sub_category psc", "psc.sub_cat_id = p.sub_cat_id", "left");
	 $this->db->group_by("p.brand_id"); 
	$this->db->order_by("p.added_time", "desc");
	
	// echo $this->db->last_query();
	 $query = $this->db->get();  
	 //echo $this->db->last_query();
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       return false;
     }
   } 
   
   function getSupplierProductsForReport($srh_warehouse_id,$supplier_srh)
   {
	 $q='';
	 $q="SELECT p.*,s.supp_company_name,s.supp_code,SUM(IF(ft.fi_type_id ='sale', ft.fi_qty, 0)) AS sold_qty, 		SUM(IF(ft.fi_type_id ='grn', ft.fi_qty, 0)) AS purchased_qty
		FROM master_brand p 
		LEFT JOIN purchase_items pi ON pi.brand_id = p.brand_id 
		LEFT JOIN purchases pu ON pu.id = pi.purchase_id
		LEFT JOIN supplier s ON s.supp_id = pu.supplier_id
		LEFT JOIN fi_table ft ON ft.fi_item_id = p.brand_id AND (ft.fi_type_id ='sale' OR ft.fi_type_id ='grn')";
		if($supplier_srh){
			$q.="WHERE pu.supplier_id=$supplier_srh";	
		}else {
			$q.="WHERE p.brand_id!=0";
		}
		$q.=" GROUP BY p.brand_id  
		ORDER BY p.added_time desc";
		
		//echo "<br/>:".$q;
     $query=$this->db->query($q);
		
	
	 //echo $this->db->last_query();
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       return false;
     }
   }
   
   function get_brand_by_name($name='',$brand_id='')
   {
     $this->db->select('p.*');
     $this->db->from('master_brand p');
    
     $this->db->where('p.brand_name',$name);
	 if($brand_id){
	 $this->db->where_not_in("p.brand_id",$brand_id);
	 }
	  $this->db->order_by("p.brand_name", "asc");
     $query = $this->db->get();  
     if($query->num_rows() >0)
     {
       return $query->row();
     }
     else
     {
       return false;
     }
   }
   
   
   function get_brand_by_id($brand_id='')
   {
     $this->db->select('*');
     $this->db->from('master_brand');
     $this->db->where('brand_id',$brand_id);
     $query = $this->db->get();  
     if($query->num_rows() >0)
     {
       return $query->row_array();
     }
     else
     {
       return false;
     }
   }
   
   function get_sub_cat_name_by_id($id)
   {
	$this->db->select('s.sub_cat_name');
     $this->db->from('brand_sub_category s');
	 $this->db->where("s.sub_cat_id",$id);
     $query = $this->db->get();
	 
	// echo $this->db->last_query();
   
     if($query->num_rows() >0)
     {
		// $name=$query->result();
		return $data['sub_cat_name']=$query->row()->sub_cat_name;
      
     }
     else
     {
       return false;
     }   
   }

   function get_warehouse_brand($brand_id='')
   {
     $this->db->select("w.name ,w.code , wp.quantity");
     $this->db->from("warehouses_brands wp");
     $this->db->join("warehouses w","wp.warehouse_id = w.id","left");
     $this->db->where("wp.brand_id",$brand_id);
     $query = $this->db->get();  
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       return false;
     }
   }

   function get_subcategory()
   {
     $this->db->select('*');
     $this->db->from('brand_sub_category');
     $query = $this->db->get();
   
     if($query->num_rows() >0)
     {
       return $query->result();
     }
     else
     {
       return false;
     }
   }

    function update_brand($prduct_id , $brand_name,$brand_code,$category,$subcategory,$unit,$brand_cost,$brand_price,$wholesale_price,$credit_salling_price,$tax,$alert_quty,$imgName,$imageThumb,$brand_details,$brand_part_no,$brand_oem_part_number,$store_position,$brand_max_qty,$daily_rental_days,$rep_commisison,$down_payment,$per_day_rental)

   {



    $data1 = array(

       'cat_id'             => $category,

       'sub_cat_id'           => $subcategory,

       'brand_name'         => $brand_name,

       'brand_code'     => $brand_code,

       'brand_image'          => $imgName,

       'brand_thumb'      => $imageThumb,

       'brand_alert_qty'    => $alert_quty,

       'brand_unit'       => $unit,

       'brand_cost'       => $brand_cost,

       'brand_price'      => $brand_price,

       'wholesale_price'      => $wholesale_price,

       'credit_salling_price'   => $credit_salling_price,

       'tax'            => $tax,

       'brand_details'    => $brand_details,
        'brand_part_no' => $brand_part_no,
		'brand_oem_part_number' => $brand_oem_part_number,
		'store_position'=>$store_position,
		'brand_max_qty'=>$brand_max_qty,
		'daily_rental_days'=>$daily_rental_days,
		'rep_commision'=>$rep_commisison,
		'down_payment'=>$down_payment,
		'per_day_rental'=>$per_day_rental

    );



    $data2 = array(

       'cat_id'             => $category,

       'sub_cat_id'           => $subcategory,

       'brand_name'         => $brand_name,

       'brand_code'     => $brand_code,

       'brand_alert_qty'    => $alert_quty,

       'brand_unit'       => $unit,

       'brand_cost'       => $brand_cost,

       'brand_price'      => $brand_price,

       'wholesale_price'      => $wholesale_price,

       'credit_salling_price'   => $credit_salling_price,

       'tax'            => $tax,

       'brand_details'    => $brand_details,
	    'brand_part_no' => $brand_part_no,
		'brand_oem_part_number' => $brand_oem_part_number,
		'store_position'=>$store_position,
		'brand_max_qty'=>$brand_max_qty,
		'daily_rental_days'=>$daily_rental_days,
		'rep_commision'=>$rep_commisison,
		'down_payment'=>$down_payment,
		'per_day_rental'=>$per_day_rental


    );



    ; 



      if (!empty($imgName) && !empty($imageThumb)) {

        $data = $data1;

      }else{

        $data = $data2;

      }



      $this->db->where('brand_id', $prduct_id);

     if($this->db->update('master_brand', $data))

     {

       return true;

     }

     else

     {

       return false;

     }


   }

public function delete_brand($brand_id='')
{
  if ($this->check_del($brand_id)) {
       return false;
  } else {
      $this->db->delete('master_brand', array('brand_id' => $brand_id));
      return true;
  }
  
}

function check_del($brand_id='')
{
  $this->db->select('brand_id');
  $this->db->from('purchase_items');
  $this->db->where('brand_id',$brand_id);
  $query = $this->db->get();
  if($query->num_rows() > 0)
  {
    return true;
  }
  else{

    return false;
  }

}

function get_item_qty($brand_id='')
{
  $this->db->select('SUM(p.quantity) AS qty');
  $this->db->from('purchase_items p');
  $this->db->where('p.brand_id',$brand_id);
  $query = $this->db->get();
  if($query->result())
  {
    return $query->result();
  }
  else{

    return false;
  }
}

	function get_search_brand($str) {
        $this->db->select('c.*');
        $this->db->from('master_brand c');
       
        $this->db->order_by("c.brand_name", "asc");
        $this->db->or_like('c.brand_name',$str);
	    $this->db->LIMIT(50);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }
    }

}
